/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.php.debug.core;

import com.aptana.core.logging.IdeLog;
import com.aptana.php.debug.PHPDebugPlugin;
import com.aptana.php.debug.core.IPHPDebugLaunchSupport;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

public class PHPDebugSupportManager {
    private static final String DEBUGGER_SUPPORT_EXTENSION = "debuggerSupport";
    private static final String LAUNCH_SUPPORT_ITEM = "launchSupport";
    private static final String CLASS_ATTR = "class";
    private static PHPDebugSupportManager instance;
    private IPHPDebugLaunchSupport launchSupport;

    private PHPDebugSupportManager() {
        this.load();
    }

    public static PHPDebugSupportManager getInstance() {
        if (instance == null) {
            instance = new PHPDebugSupportManager();
        }
        return instance;
    }

    public static IPHPDebugLaunchSupport getLaunchSupport() {
        return PHPDebugSupportManager.getInstance().launchSupport;
    }

    private void load() {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.aptana.php.debug", DEBUGGER_SUPPORT_EXTENSION);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (LAUNCH_SUPPORT_ITEM.equals(element.getName()) && element.getAttribute(CLASS_ATTR) != null) {
                try {
                    this.launchSupport = (IPHPDebugLaunchSupport)element.createExecutableExtension(CLASS_ATTR);
                }
                catch (CoreException e) {
                    IdeLog.logError((Plugin)PHPDebugPlugin.getDefault(), (Throwable)e, (String)"com.aptana.php.debug/debug");
                }
            }
            ++n2;
        }
    }
}

